package java.game.cars;

import java.util.*;
import java.util.resource.*;
import java.game.parts.bodypart.*;


public class Coyot_RL_door extends RearDoor
{
	public Coyot_RL_door( int id )
	{
		super( id );
		carCategory = PACKAGE;
		name = "Coyot rear left door";

		value = 250;
	}
	
	public void addStockParts( int actcolor, float optical, float power )
	{
		super.addStockParts( actcolor, optical, power );

		randomize( optical + power );

		// parts that have only one appearance //
		if ( optical >= 1.0 )
		{
			addPart( cars.cat_01.coyot:0x000000F0r, "RL window", actcolor, optical, power );
		} else
		{
			if ( optical >= random() ) addPart( cars.cat_01.coyot:0x000000F0r, "RL window", actcolor, optical, power );
		}
	}
}
